# Overview of the assessment scoring criteria on taxonomy pages

The taxonomy analysis has the same SEO, Readability, and Inclusive language scoring criteria as posts and pages, except for the SEO assessments below:

## 1) Taxonomy text length assessment
**What it does**: Checks if the taxonomy page has a good length.

**When applies**: Always.

**Name in code**: TaxonomyTextLengthAssessment

**Title URL**: https://yoa.st/34j (link placement is in bold in the feedback strings)

**Call to action URL**: https://yoa.st/34k (link placement is in bold in the feedback strings)

| Traffic light	 | Score	| Criterion	           | Feedback                                                                                                           |
|----------------|------------------	|----------------------|-----------------------------------------------------------------------------------------------------------------|
| Red	           | -20	| 0 words	             | Text length: Please add some content.                                          |
| Red	           | 3	| From 1 to 9 words	   | Text length: The text contains X words. This is below the recommended minimum of 30 words. Add more content.       |
| Orange         | 6	| From 10 to 29 words	 | Text length: The text contains X words. This is slightly below the recommended minimum of 30 words. Add more content. |
| Green	         | 9	| 30 words or more	    | Text length: The text contains X words. Good job!                                                                  |

## 2) Meta description length assessment
**What it does**: Checks if the meta description has a good length. In a taxonomy page, the date is not displayed or included in the meta description. Hence, the date length is not included in the calculation for this assessment.

**When applies**: Always.

**Name in code**: MetaDescriptionLengthAssessment

**Title URL**: [https://yoa.st/34d](https://yoast.com/meta-descriptions/#utm_source=yoast-seo&utm_medium=software&utm_term=length-meta-description-name&utm_content=content-analysis) (link placement is in bold in the feedback strings)

**Call to action URL**: [https://yoa.st/34e](https://yoast.com/meta-descriptions/#utm_source=yoast-seo&utm_medium=software&utm_term=length-meta-description-name&utm_content=content-analysis) (link placement is in bold in the feedback strings)

| Traffic light   	            | Score	     | Criterion | Feedback |
|------------------------------|------------------	|---------------------	|---------------	|
| Red	                         | 1	| No meta description		| **Meta description length**: No meta description has been specified. Search engines will display copy from the page instead. **Make sure to write one!** |
| Orange (corner stone: red)		 | 6 (corner stone: 3)		| Meta description ≤ 120 characters		| **Meta description length**: The meta description is too short (under X characters). Up to X characters are available. **Use the space!** |
| Orange (corner stone: red)		 | 6 (corner stone: 3)		| Meta description ≥ 157 characters		| **Meta description length**: The meta description is over X characters. **To ensure the entire description will be visible, you should reduce the length!**	|
| Green	                       | 9	| Meta description > 120 and < 157		| **Meta description length**: Well done! |

